/* NCurses wrappers */
#include <stdio.h>
#include <stdarg.h>
#include <errno.h>
#include <time.h>
#include <ncurses.h>

#include "main.h"

/* print formatted, use either printf() or printw()/refresh() */
int xprintf(const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	int ret;

	if(opt_batch) {
		ret = vprintf(fmt, ap);
	} else {
		ret = vwprintw(stdscr, fmt, ap);
	}

	va_end(ap);
	return(ret);
}

/* refresh screen */
int xrefresh(void)
{
	if(opt_batch)
		return(OK);
	else
		return(refresh());
}

/* clear screen */
int xclear(void)
{
	if(opt_batch)
		return(OK);
	else
		return(clear());
}

/* clear until end of line */
int xclrtoeol(void)
{
	if(opt_batch)
		return(OK);
	else
		return(clrtoeol());
}

/* move cursor */
int xmove(int y, int x)
{
	if(opt_batch)
		return(OK);
	else
		return(move(y, x));
}

/* turn attribute on */
int xattron(int attrs)
{
	if(opt_batch)
		return(attrs);
	else
		return(attron(attrs));
}

/* turn attribute off */
int xattroff(int attrs)
{
	if(opt_batch)
		return(attrs);
	else
		return(attroff(attrs));
}

/* blocking delay, using nanosleep() */
void xdelay(float val)
{
	int ret;

	/* return early */
	if(val <= 0)
		return;

	/* time to wait */
	struct timespec tm = {
		(int)val,
		(int)((val - (int)val) * 1000000000)
	};

	/* do the wait */
	do {
		ret = nanosleep(&tm, &tm);
	} while(ret == -1 && errno == EINTR);
}
