#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <e-hal.h>
#include <e-loader.h>


int main(int argc, char *argv[]) {
	const int coreRows = 1;
	const int coreCols = 1;
	e_platform_t epiphany;
	e_epiphany_t dev;
	
	e_init(NULL);
	e_reset_system();
	e_get_platform_info(&epiphany);
	e_open(&dev, 0, 0, coreRows, coreCols);
	e_reset_group(&dev);

	
	int array[5];
	memset(array, 0, sizeof(array));
	
	//allocate memory segment
	e_mem_t shmSeg;
	if(e_shm_alloc(&shmSeg, "testseg", sizeof(array)) != E_OK) {
		fprintf(stderr, "e_shm_alloc failed (%d bytes). %s!\n", sizeof(array), strerror(errno));
		exit(EXIT_FAILURE);
	}
	
	//copy array to shm
	e_write(&shmSeg, 0, 0, 0, array, sizeof(array));

	//load and start program on epiphany
	e_load_group("epiphany_hello.srec", &dev, 0, 0, coreRows, coreCols, E_FALSE);
	e_start_group(&dev);
	

	//fetch array from shm until the last value is not 0
	e_read(&shmSeg, 0, 0, 0, array, sizeof(array));
	while(!array[4])
		e_read(&shmSeg, 0, 0, 0, array, sizeof(array));
	
	//output values
	printf("%d %d %d %d %d\n", array[0], array[1], array[2], array[3], array[4]);
	
	e_shm_release("testseg");
	e_finalize();

	return 0;
}
