#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>

#include "e_lib.h"

#include "simpleMath.h"

#define _NumElements    1024

uint8_t volatile *const barrier           = (void *) 0x3FFF ; /**< If barrier == 1 the core busy waits till the host resets it to 0.*/
float volatile (*const a)[_NumElements]   = (void *) 0x4000;
float volatile (*const b)[_NumElements]   = (void *) 0x5000;
float volatile (*const c)[_NumElements]   = (void *) 0x6000;

/** @brief Wait till host remove barrier lock. */
inline void barrier_worker() {
  *barrier = 1;
  while( *barrier ) {}
}

/** @brief Worker main application. */
int main(void) {

  while(1) {
    // sync workers 
    barrier_worker();

    // do simple math on X similar elements
    for(uint32_t i=0; i < _NumElements; i++)
    {
      simpleMath1( &((*a)[i]), &((*b)[i]), &((*c)[i]) );
    }
  } 

  return EXIT_SUCCESS;
}
