#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <math.h>

#include "e_lib.h"

#include "simpleMath.h"

#define _NumElements 1024

uint8_t volatile *const barrier           = (void *) 0x3FFF ; /**< If barrier == 1 the core busy waits till the host resets it to 0.*/
off_t *a_ptr                              = (void *) 0x4000 ;
off_t *b_ptr                              = (void *) 0x4010 ;
off_t *c_ptr                              = (void *) 0x4020 ;

/** @brief Wait till host remove barrier lock. */
inline void barrier_worker() {
  *barrier = 1;
  while( *barrier ) {}
}

/** @brief Worker main application. */
int main(void) {

  float  a[_NumElements] = {0};
  *a_ptr = (off_t)a;
  float  b[_NumElements] = {0};
  *b_ptr = (off_t)b;
  float  c[_NumElements] = {0};
  *c_ptr = (off_t)c;

  barrier_worker();

  while(1) {
    // sync workers 
    barrier_worker();

    // do simple math on X similar elements
    for(uint32_t i=0; i < _NumElements; i++)
    {
      c[i] = simpleMath6( a[i], b[i], c[i] );
    }
  } 

  return EXIT_SUCCESS;
}
