// clang-format off
#ifndef SIMPLEMATH_H
#define SIMPLEMAHT_H

inline void simpleMath1(float volatile *a, float volatile *b, float volatile *c)
{
  *c = *a + *b;
}

inline void simpleMath2(float volatile *a, float volatile *b, float volatile *c)
{
  *c += 0.1 * (-(*c) - 0.4)/128.0 + 0.1 * (*a)/(*b + 0.3);
}

inline float simpleMath3(float a, float b, float c)
{
  return c + 0.1 * (-c - 0.4)/128.0 + 0.1 * a/(b + 0.3);
}

inline float simpleMath5(float a, float b, float c)
{
  float x,y,z;
  x = -c -0.4;
  y =  b +0.3;
  y = 1.0/y;
  y = y * 0.1 * a;
  z = 0.1*x*0.0078125;

  return c + z + y;
}

inline float simpleMath6(float a, float b, float c)
{
  return a * b;
}

inline float simpleMath7(float a, float b, float c)
{
  return a * b * c;
}

inline float simpleMath8(float a, float b, float c)
{
  return a*b + b*c + c*a;
}

inline float simpleMath9(float a, float b, float c)
{
  return a + b + c;
}

inline float simpleMath10(float a, float b, float c)
{
  return a + b + c + a/3.0;
}

inline float simpleMath11(float a, float b, float c)
{
  return a/3.33;
}

inline float simpleMath12(float a, float b, float c)
{
  return a/(float)3.33;
}

inline float simpleMath13(float a, float b, float c)
{
  return a/b + b/c + c/a;
}

inline float simpleMath14(float a, float b, float c)
{
  return a/(float)b + b/(float)c + c/(float)a;
}

// clang-format on
#endif /* #ifndef SIMPLEMATH_H */
