#include <e_coreid.h>
#include <e_ctimers.h>
#include <e_dma.h>
#include <e_mutex.h>
#ifdef NDEBUG
	#include "shared_data.h"
#else
	#include "../../EWHMHost/shared_data.h"
#endif
#ifdef PRINT_FROM_CORE
	#include "printf.c"
#endif

/* Add in this module code that is common to all cores */
#define BUF_ADDRESS SHARED_DATA_OFFSET_EPIPHANY
#define MAILBOX_BUF_ADDRESS (BUF_ADDRESS)
#define BARRIER_ARRAY_ADDRESS (MAILBOX_BUF_ADDRESS + sizeof(msg_block_t))


const int TEST_CORE=0;

uint32_t mappedcore;

int *other_core_from_above_value_holder;
int *other_core_from_below_value_holder;

#ifdef NDEBUG
	e_barrier_t  barriers[CORES]; // barriers array
	e_barrier_t *tgt_bars[CORES]; // barriers array

	void do_barrier()
	{
		e_barrier(barriers, tgt_bars);
	}
#else

	volatile barrier_data_t *bdata = (barrier_data_t*)BARRIER_ARRAY_ADDRESS;
	void do_barrier()
	{
		volatile uint32_t *lastSeqNum = &bdata->last_released_sequence_num;
		uint32_t nextSeqNum = *lastSeqNum;
		nextSeqNum++;
		bdata->barrier_count[mappedcore]=nextSeqNum;
		volatile uint32_t *updatedSequenceNum = &bdata->last_released_sequence_num;
		while (*updatedSequenceNum!=nextSeqNum)
		{
			if (mappedcore==0)
			{
				int i;
				unsigned char not_updated=0;
				for (i=0;i<CORES;i++)
				{
					volatile uint32_t *coreSequenceNum = &bdata->barrier_count[i];
					if (*coreSequenceNum!=nextSeqNum)
					{
						not_updated++;
					}
				}
				if (not_updated==0)
				{
					// all cores have been set, release barrier
					bdata->last_released_sequence_num=nextSeqNum;
				}
			}
		}
	}
#endif

	void xsleep(unsigned int n)
	{
		unsigned int i, total;
		for (i=0;i<n*100000000;i++)
		{
			total+=i;
			total=total % 256;
		}
#ifdef PRINT_FROM_CORE
		printf("Total from sleep is %u\n", total);
#endif
	}

int mc_core_common_go()
{

	#ifdef NDEBUG
		e_barrier_init(barriers, tgt_bars);
	#endif


	volatile msg_block_t *msg = (msg_block_t *)MAILBOX_BUF_ADDRESS;


	volatile uint32_t *goflag = (uint32_t *)&msg->host_ready;

	int status = 0;
	e_coreid_t coreid = e_get_coreid();
	unsigned int row, col;
	e_coords_from_coreid(coreid, &row, &col);

	#ifndef NDEBUG
		unsigned int originrow=32,origincol=8;
	#else
		unsigned int originrow=0,origincol=0;
	#endif





	unsigned int mappedcorerow=row-originrow;
	unsigned int mappedcorecol=col-origincol;

	mappedcore = mappedcorerow * COLS + mappedcorecol;

	#ifdef PRINT_USING_STATUS
		printable_output_buffer=&msg->core_status[mappedcore].status_text[0];
		status_waiting_flag=&msg->core_status[mappedcore].status_waiting;
	#endif

	#ifdef PRINT_FROM_CORE
		printf("Mapped core coordinates are %u,%u\n",mappedcorerow,mappedcorecol);
	#endif

	#ifdef PRINT_FROM_CORE
		printf("SIZEOF MSG: %u\n",sizeof(msg_block_t));
		printf("ADDRESS: cr: %u\n", &msg->cores_ready);
		printf("ADDRESS: hr: %u\n", &msg->host_ready);
		printf("ADDRESS: cf: %u\n", &msg->cores_finished);
		//printf("ADDRESS: tb: %u\n", &msg->transmitted_boundaries);
		printf("Hello world from core (%d, %d)\n", row, col);
		unsigned int core = row * COLS + col;
		printf("Core is %u\n", core);
	#endif


	#ifdef PRINT_FROM_CORE
		printf("Mapped core is %u\n", (unsigned int)mappedcore);
	#endif

	#ifndef NDEBUG
		if (mappedcore==TEST_CORE)
		{
			#ifdef PRINT_FROM_CORE
				printf("Current core (%u) is the TEST CORE\n", mappedcore);
			#endif
		}
	#endif



	// below
	// this will store the value we receive when we are the below core
	volatile int received_from_above_value=0;
	msg->from_above_values_addresses[mappedcore]=e_get_global_address(row,col,&received_from_above_value);

	// for sending to below
	#define BELOW_DMA_CHANNEL E_DMA_0
	int below_core_to_write_to=mappedcore-1;
	if (below_core_to_write_to==-1) below_core_to_write_to=CORES-1;
	int value_to_copy_to_below=10000+mappedcore;





	// above
	// this will store the value we receive when we are the above core
	volatile int received_from_below_value=0;
	msg->from_below_values_addresses[mappedcore]=e_get_global_address(row,col,&received_from_below_value);

	// for sending to above
	#define ABOVE_DMA_CHANNEL E_DMA_1
	int above_core_to_write_to=mappedcore+1;
	if (above_core_to_write_to==CORES) above_core_to_write_to=0;
	int value_to_copy_to_above=20000+mappedcore;



	do_barrier();

	if (mappedcore==0) msg->cores_ready=1;

	#ifdef PRINT_FROM_CORE
		printf("Core %u waiting for GO Flag\n", mappedcore);
	#endif
	while (*goflag!=1);
	#ifdef PRINT_FROM_CORE
		printf("Core %u received GO Flag\n", mappedcore);
	#endif

    // store my neightbour's receiving variables addresses

	// below
	e_dma_desc_t dma_copy_to_below_struct;
    int *other_core_from_above_value_holder=msg->from_above_values_addresses[below_core_to_write_to];
    e_dma_set_desc(BELOW_DMA_CHANNEL,(E_DMA_ENABLE|E_DMA_MASTER|E_DMA_WORD),NULL,sizeof(int),sizeof(int),1,1,0,0,&value_to_copy_to_below,other_core_from_above_value_holder,&dma_copy_to_below_struct);
	#ifdef PRINT_FROM_CORE
        printf("Set below DMA\n");
	#endif

	// above
	e_dma_desc_t dma_copy_to_above_struct;
	int *other_core_from_below_value_holder=msg->from_below_values_addresses[above_core_to_write_to];
	e_dma_set_desc(ABOVE_DMA_CHANNEL,(E_DMA_ENABLE|E_DMA_MASTER|E_DMA_WORD),NULL,sizeof(int),sizeof(int),1,1,0,0,&value_to_copy_to_above,other_core_from_below_value_holder,&dma_copy_to_above_struct);
	#ifdef PRINT_FROM_CORE
		printf("Set above DMA\n");
	#endif


#ifndef NDEBUG
    if (mappedcore==TEST_CORE)
    {
		#ifdef PRINT_FROM_CORE
    		printf("This is the test core\n", mappedcore);
		#endif
    }
#endif

    int iterations=2;
    int i;
    for (i=0;i<iterations;i++)
    {
    	value_to_copy_to_below+=(100*i);
    	value_to_copy_to_above+=(100*i);
		// send below
		e_return_stat_t to_below_result = e_dma_start(&dma_copy_to_below_struct, BELOW_DMA_CHANNEL);
		#ifdef PRINT_FROM_CORE
			if (to_below_result!=E_OK)
			{
				printf("Error starting to send to below using DMA: %d\n",to_below_result);
			}
			printf("Completed starting sending below\n");
		#endif

		e_dma_wait(BELOW_DMA_CHANNEL);

		// send above
		e_return_stat_t to_above_result = e_dma_start(&dma_copy_to_above_struct, ABOVE_DMA_CHANNEL);
		#ifdef PRINT_FROM_CORE
			if (to_above_result!=E_OK)
			{
				printf("Error starting to send to above using DMA: %d\n",to_above_result);
			}
			printf("Completed starting sending above\n");
		#endif

		e_dma_wait(ABOVE_DMA_CHANNEL);

		// wait a second
        do_barrier(); // make sure all threads have sent (i.e. the one I'm relying on)
        xsleep(1);

        	msg->from_above_values[mappedcore]=received_from_above_value;
			#ifdef PRINT_FROM_CORE
        		printf("Show received from above: %u\n",(unsigned int)(received_from_above_value));
			#endif

        	msg->from_below_values[mappedcore]=received_from_below_value;
			#ifdef PRINT_FROM_CORE
        		printf("Show received from below: %u\n",(unsigned int)(received_from_below_value));
			#endif

		do_barrier();  // make sure I'm allowed time to copy it
        xsleep(1);

        // copy to above
    }
	// finished work
	do_barrier();
	xsleep(1);
	if (mappedcore==0)
	{
		// copy the grid
		msg->cores_finished=1;
	}

	return status;
}
