/*
 * main.c
 *
 *  Created on: 20 Jan 2014
 *      Author: epiphany
 */
#include <stdlib.h>
#include <stdio.h>
#include <e-hal.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include "shared_data.h"

#define BUF_OFFSET SHARED_DATA_OFFSET_GLOBAL
#define MAILBOX_BUF_OFFSET (BUF_OFFSET)
#define BARRIER_DATA_OFFSET (MAILBOX_BUF_OFFSET + (sizeof(msg_block_t)))

int main(void)
{
	printf("SIZEOF MSG: %u\n",sizeof(msg_block_t));

	printf("Hello from ARM!!\n");





	printf("***Init\n");
	e_return_stat_t result = e_init(NULL);
	if (result != E_OK)
	{
		if (result == E_ERR)
		{
			printf("Failed to initialise - exiting");
			return -1;
		}
		else
		{
			printf("Warning when initialising");
		}

	}

	//e_set_host_verbosity(H_D4);

#ifdef NDEBUG
		printf("***Reset\n");
		result = e_reset_system();
		if (result != E_OK)
		{
			if (result == E_ERR)
			{
				printf("Failed to reset system - exiting");
				return -1;
			}
			else
			{
				printf("Warning when resetting");
			}
		}
#endif

	// get some info
	e_platform_t platform_info;
	result = e_get_platform_info(&platform_info);
	if (result != E_OK)
	{
		if (result == E_ERR)
		{
			printf("Failed to get platform info - exiting");
			return -1;
		}
		else
		{
			printf("Warning when getting platform info");
		}
	}

	// print some info
	printf("Version: %s\n", platform_info.version);
	printf("HAL Version: %u\n", platform_info.hal_ver);
	printf("Row,Col: %u,%u\n", platform_info.row, platform_info.col);
	printf("Rows,Cols: %u,%u\n", platform_info.rows, platform_info.cols);



#ifndef NDEBUG
	  printf("***Alloc Barriers\n");
	  barrier_data_t bdata;
	  memset(&bdata,0,sizeof(barrier_data_t));
	  e_mem_t barrier_mem;
	  result = e_alloc (&barrier_mem, BARRIER_DATA_OFFSET, sizeof(barrier_data_t));
		if (result != E_OK)
		{
			if (result == E_ERR)
			{
				printf("Failed to allocate BarrierData - exiting");
				return -1;
			}
			else
			{
				printf("Warning when allocating BarrierData");
			}
		}
		else
		{
			e_write(&barrier_mem,0,0,0,&bdata,sizeof(barrier_data_t));
		}
		printf("Barriers Allocated\n");
#endif


	  // allocate mailboxes
	  static msg_block_t msg;
	  memset(&msg, 0, sizeof(msg));
	  e_mem_t mailboxmem;
	  e_alloc(&mailboxmem, MAILBOX_BUF_OFFSET, sizeof(msg_block_t));
	  e_write(&mailboxmem, 0, 0, 0, &msg, sizeof(msg));

printf("***Check Debug\n");
#ifdef NDEBUG
	  printf("***Open\n");
	  e_epiphany_t edev;
	  result = e_open(&edev, 0,0, ROWS, COLS);
		if (result != E_OK)
		{
			if (result == E_ERR)
			{
				printf("***Error opening device - exiting\n");
				return -1;
			}
			else
			{
				printf("***Warning when opening device\n");
			}
		}

//e_reset_core(&edev,0,0);

		printf("***Load\n");
		result=e_load_group("epiphany.srec",&edev,0,0,ROWS,COLS,E_TRUE);
		if (result != E_OK)
		{
			if (result == E_ERR)
			{
				printf("***Error loading group - exiting\n");
				fflush(NULL);
				return -1;
			}
			else
			{
				printf("***Warning when loading group\n");
				fflush(NULL);
			}
		}


#endif

printf("***Past DEBUG check\n");
//e_reset_core(&edev,0,0);
//result=e_start(&edev,0,0);
if (result != E_OK)
{
	if (result == E_ERR)
	{
		printf("***Error starting group - exiting\n");
		fflush(NULL);
		return -1;
	}
	else
	{
		printf("***Warning when starting group\n");
		fflush(NULL);
	}
}





printf("***Waiting for ready signal from cores\n");
while (!msg.cores_ready)
{
	e_read(&mailboxmem,0,0,0,&msg,sizeof(msg));
#ifdef PRINT_USING_STATUS
	int i;
	for (i=0;i<CORES;i++)
	{
		if (msg.core_status[i].status_waiting)
		{
			printf("Core %u: %s",i,msg.core_status[i].status_text);
			msg.core_status[i].status_waiting=0;
			// need to write this
			// get the address of msg
			// then get the address of this field
			// then I will know the offset
			unsigned char *msgPointerAddress = (unsigned char*)&msg;
			unsigned char *status_flag_address = (unsigned char*)&msg.core_status[i].status_waiting;
			long int status_waiting_offset = status_flag_address - msgPointerAddress;
			e_write(&mailboxmem, 0, 0, status_waiting_offset, &msg.core_status[i].status_waiting, sizeof(msg.core_status[i].status_waiting));
		}
	}
#endif
}

// all cores reported, now give them some work
msg.host_ready=1;
e_write(&mailboxmem, 0, 0, 0, &msg, sizeof(msg));

// get the time
struct timeval start_time, end_time, total_time;
printf("GO!\n");
gettimeofday(&start_time,NULL);

// wait for them to finish
while (msg.cores_finished!=1)
{
	e_read(&mailboxmem, 0, 0, 0, &msg, sizeof(msg));
#ifdef PRINT_USING_STATUS
	int i;
	for (i=0;i<CORES;i++)
	{
		if (msg.core_status[i].status_waiting)
		{
			printf("Core %u: %s",i,msg.core_status[i].status_text);
			msg.core_status[i].status_waiting=0;
			// need to write this
			// get the address of msg
			// then get the address of this field
			// then I will know the offset
			unsigned char *msgPointerAddress = (unsigned char*)&msg;
			unsigned char *status_flag_address = (unsigned char*)&msg.core_status[i].status_waiting;
			long int status_waiting_offset = status_flag_address - msgPointerAddress;
			e_write(&mailboxmem, 0, 0, status_waiting_offset, &msg.core_status[i].status_waiting, sizeof(msg.core_status[i].status_waiting));
		}
	}
#endif
}
// read it one more time
e_read(&mailboxmem, 0, 0, 0, &msg, sizeof(msg));

gettimeofday(&end_time, NULL);

unsigned int total=0;
unsigned int i;


// print the grid
printf("Message offset: %u\n",MAILBOX_BUF_OFFSET);
void *final_grid_address = &msg.from_above_values;
printf("Final grid address from host:    %u   x\n",(unsigned int)final_grid_address);
for (i=0;i<CORES;i++)
{
		printf("%u: %u %u\n",i,msg.from_above_values[i], msg.from_below_values[i]);
}

timersub(&end_time,&start_time,&total_time);
printf("Time taken: %ld.%06ld seconds\n",total_time.tv_sec, total_time.tv_usec);
#ifdef NDEBUG
	  e_close(&edev);
#endif

	  e_free(&mailboxmem);

#ifndef NDEBUG
	  e_free(&barrier_mem);
#endif


	result = e_finalize();
	if (result != E_OK)
	{
		printf("Failed to finalise - exiting");
		return -1;
	}


	return EXIT_SUCCESS;
}
