/*
 * shared_data.h
 *
 *  Created on: 5 Feb 2014
 *      Author: epiphany
 */

#ifndef SHARED_DATA_H_
#define SHARED_DATA_H_

#include <stdint.h>

#define SHARED_DATA_OFFSET_GLOBAL (0x01000000)
#define SHARED_DATA_OFFSET_EPIPHANY (SHARED_DATA_OFFSET_GLOBAL + 0x8e000000)

#define FORCEALIGN 8

#define ROWS 4
#define COLS 4
#define CORES (ROWS*COLS)

#ifndef NDEBUG
#define PRINT_FROM_CORE 1
#endif

#ifdef NDEBUG
#ifdef PRINT
#define PRINT_FROM_CORE 1
#define PRINT_USING_STATUS 1
#endif
#endif

#ifdef PRINT_FROM_CORE
#define OUTPUT_BUFFER_SIZE 256
#endif

#ifdef PRINT_USING_STATUS
typedef struct __attribute__((aligned(FORCEALIGN)))
{
	unsigned int status_waiting;
	unsigned char status_text[OUTPUT_BUFFER_SIZE] __attribute__((aligned(FORCEALIGN)));
} status_update;
#endif

typedef struct __attribute__((aligned(FORCEALIGN)))
{
  uint32_t cores_ready;
  uint32_t host_ready;
  uint32_t cores_finished;
  int *from_above_values_addresses[CORES] __attribute__((aligned(FORCEALIGN)));
  int from_above_values[CORES] __attribute__((aligned(FORCEALIGN)));
  int *from_below_values_addresses[CORES] __attribute__((aligned(FORCEALIGN)));
  int from_below_values[CORES] __attribute__((aligned(FORCEALIGN)));
#ifdef PRINT_USING_STATUS
  status_update core_status[CORES] __attribute__((aligned(FORCEALIGN)));
#endif
} msg_block_t;

#ifndef NDEBUG
typedef struct __attribute__((aligned(FORCEALIGN)))
{
	uint32_t barrier_count[CORES] __attribute__((aligned(FORCEALIGN)));
	uint32_t last_released_sequence_num;
} barrier_data_t;
#endif

#endif /* SHARED_DATA_H_ */
